#pragma once
#include "graph.hpp"

struct BridgeFinder {
    const Graph& g;
    std::vector<int> tin, low;
    std::vector<bool> used;
    int timer = 0;
    std::vector<int> bridges;

    BridgeFinder(const Graph& g)
        : g(g), tin(g.n, -1), low(g.n, -1), used(g.n, false) {}

    void dfs(int v, int pe) {
        used[v] = true;
        tin[v] = low[v] = timer++;
        for (auto e : g.adj[v]) {
            if (e.id == pe) continue;
            if (used[e.to]) {
                low[v] = std::min(low[v], tin[e.to]);
            }
            else {
                dfs(e.to, e.id);
                low[v] = std::min(low[v], low[e.to]);
                if (low[e.to] > tin[v])
                    bridges.push_back(e.id);
            }
        }
    }

    void run() {
        for (int i = 0; i < g.n; ++i)
            if (!used[i])
                dfs(i, -1);
    }
};
